#include <stdio.h>
#include <stdlib.h>

#define MAXN 200005

typedef long long ll;

int N, Q;
int a[MAXN];
int freq[MAXN], last[MAXN];

int cmp(const void *A, const void *B) {
    ll x = *(ll *)A;
    ll y = *(ll *)B;
    if (x < y) return 1;
    if (x > y) return -1;
    return 0;
}

int main() {
    scanf("%d %d", &N, &Q);
    for (int i = 1; i <= N; i++) {
        scanf("%d", &a[i]);
    }

    while (Q--) {
        int t;
        scanf("%d", &t);

        if (t == 2) {
            int x, y;
            scanf("%d %d", &x, &y);
            a[x] = y;
            continue;
        }

        int k;
        scanf("%d", &k);

        for (int i = 1; i <= N; i++) {
            freq[i] = 0;
            last[i] = 0;
        }

        for (int i = 1; i <= N; i++) {
            freq[a[i]]++;
            last[a[i]] = i;
        }

        ll total = 0;
        for (int i = 1; i <= k; i++) total += a[i];

        int jobs = 0;
        ll profits[MAXN];

        for (int v = 1; v <= N; v++) {
            if (freq[v] == 0) continue;
            int deadline = last[v] - k;
            if (deadline < 0) deadline = 0;
            if (deadline <= N - k) {
                profits[jobs++] = (ll)v * freq[v];
            }
        }

        qsort(profits, jobs, sizeof(ll), cmp);

        ll removed = 0;
        int can = N - k;
        for (int i = 0; i < jobs && i < can; i++) {
            removed += profits[i];
        }

        printf("%lld\n", total + (ll)(0) - removed);
    }

    return 0;
}